<?php
/*
Plugin Name: League Table
Description: Generates League Tables in your WordPress blog.
Version: 2.17
Author: DAEXT
Author URI: https://daext.com
*/

//Prevent direct access to this file
if ( ! defined( 'WPINC' ) ) {
	die();
}

//Shared across public and admin
require_once( plugin_dir_path( __FILE__ ) . 'shared/class-dalt-shared.php' );

require_once( plugin_dir_path( __FILE__ ) . 'public/class-dalt-public.php' );
add_action( 'plugins_loaded', array( 'dalt_Public', 'get_instance' ) );

//Perform the Gutenberg related activities only if Gutenberg is present
if ( function_exists( 'register_block_type' ) ) {
	require_once( plugin_dir_path( __FILE__ ) . 'blocks/src/init.php' );
}

//Admin
if ( is_admin() && ( ! defined( 'DOING_AJAX' ) || ! DOING_AJAX ) ) {

	//Admin
	require_once( plugin_dir_path( __FILE__ ) . 'admin/class-dalt-admin.php' );
	add_action( 'plugins_loaded', array( 'dalt_Admin', 'get_instance' ) );

	//Activate
	register_activation_hook( __FILE__, array( dalt_Admin::get_instance(), 'ac_activate' ) );

}

//Ajax
if ( defined( 'DOING_AJAX' ) && DOING_AJAX ) {

	//Admin
	require_once( plugin_dir_path( __FILE__ ) . 'class-dalt-ajax.php' );
	add_action( 'plugins_loaded', array( 'dalt_Ajax', 'get_instance' ) );

}